//
//  MarbleViewController.m
//  Marble
//
//  Created by Jonathan Diehl on 26.11.10.
//  Copyright 2010 RWTH. All rights reserved.
//



#import "MarbleViewController.h"



@implementation MarbleViewController


#pragma mark UIViewController

- (void)viewDidLoad;
{
	[super viewDidLoad];
	
	// init marble
	marble = [[Marble alloc] initWithView:self.view];
	
	// init core motion
	motionManager = [[CMMotionManager alloc] init];
	motionManager.accelerometerUpdateInterval = 1.0/30.0;
}

- (void)viewDidUnload;
{
	[marble release];
	marble = nil;
	
	[motionManager release];
	motionManager = nil;
}

- (void)viewWillAppear:(BOOL)animated;
{
	// start core motion updates
	[motionManager startAccelerometerUpdates];
	
	// start update timer
	updateTimer = [[NSTimer scheduledTimerWithTimeInterval:1.0/30.0 target:self selector:@selector(update:) userInfo:nil repeats:YES] retain];
}

- (void)viewWillDisappear:(BOOL)animated;
{
	// stop timer
	[updateTimer invalidate];
	[updateTimer release];
	updateTimer = nil;
	
	// stop core motion updates
	[motionManager stopAccelerometerUpdates];
}

// cleanup
- (void)dealloc
{
	[marble release];
	[motionManager release];
	[super dealloc];
}


#pragma mark UIAccelerometerDelegate

// timer update
- (void)update:(NSTimer *)timer;
{
	CGPoint acceleration;
	
	// acceleration available
	if(motionManager.accelerometerAvailable) {
		CMAccelerometerData *accelerometerData = [motionManager accelerometerData];
		acceleration = CGPointMake(accelerometerData.acceleration.x, -accelerometerData.acceleration.y);
	}
	
	// fake acceleration data
	else {
		acceleration = CGPointMake(0.0, 0.8);
	}
	
	// update marble speed and position
	[marble accelerate:acceleration];
	[marble update];
}


@end
